create or replace package body tbicds.PCK_PATIENT_TX_STEP is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Insert patient step
*/
   procedure InsertPatientStep(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              
                              pi_vPatientID in varchar2,
                              pi_nStep      in number,
                              
                              po_nStatusCode    out number,
                              po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nProfile                number := 1;
      v_nStartedBaseline        number := 2;
      v_nBaselineQuestionnaires number := 4;
      v_nStartedVideos          number := 8;
      v_nVideos                 number := 16;
      v_nCPAPData               number := 32;
      v_nStep number := 0;
      v_nCount       number;
      v_nRecCount    number := 0;
      v_nCurrentStep number := 0;
   begin
      v_vSql := 'select count(*) from tbicds.patient_treatment_step where patient_id = :P0';
      execute immediate v_vSql into v_nRecCount using pi_vPatientID;
   
      if v_nRecCount > 0 then
         v_vSql := 'select treatment_step from tbicds.patient_treatment_step where patient_id = :P0';
         execute immediate v_vSql into v_nCurrentStep using pi_vPatientID;
      end if;
   
      if (bitand(v_nCurrentStep, v_nProfile) = 0) then
         -- set step value for complete patient profile (from the portal)
         -- only if this step was not set before
         if (bitand(pi_nStep, v_nProfile) = v_nProfile) then
            v_nStep := v_nStep + v_nProfile;
         end if;
      elsif (bitand(v_nCurrentStep, v_nProfile) = v_nProfile) then
         v_nStep := v_nStep + v_nProfile;
      end if;
   
      --insert step other than PROFILE
      if (bitand(pi_nStep, v_nProfile) = 0) then
         v_nStep := v_nStep + pi_nStep;
      end if;
   
      --check status of Baseline questionnaires
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_module t '
                || 'where t.patient_id = :P0 '
                || 'and (t.module_group_id = 2 and t.status = 1) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nStartedBaseline;
      end if;
   
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and (t.status = 1 and t.event_id = 5) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nBaselineQuestionnaires;
      end if;
   
      --check status of video events
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and (t.status = 1 and t.event_id in (3, 4)) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
      
      if v_nCount = 1 then
         v_nStep := v_nStep + v_nStartedVideos;
      elsif v_nCount = 2 then
         v_nStep := v_nStep + v_nStartedVideos + v_nVideos;
      end if;
   
      --check status of CPAP Data
      v_nCount := 0;
      v_vSql := 'select count(*) from tbicds.patient_cpap t where t.patient_id = :P0 ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
      
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nCPAPData;
      end if;
   
      --insert or update
      if v_nRecCount > 0 then
         v_vSql := 'update tbicds.patient_treatment_step t '
                   || 'set t.treatment_step = :P0 '
                   || 'where t.patient_id = :P1 ';
         execute immediate v_vSql using v_nStep, pi_vPatientID;
      else
         v_vSql := 'insert into tbicds.patient_treatment_step (patient_id, treatment_step) '
                   || 'values (:P0, :P1) ';
         execute immediate v_vSql using pi_vPatientID, v_nStep;
      end if;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PATIENT_TX_STEP.InsertPatientStep(): ' || sqlErrm;
   end;

   /*
   Update patient steps
   */
   procedure UpdatePatientSteps(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vPatientID in varchar2,
                               po_nStatusCode    out number,
                               po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nProfile                number := 1;
      v_nStartedBaseline        number := 2;
      v_nBaselineQuestionnaires number := 4;
      v_nStartedVideos          number := 8;
      v_nVideos                 number := 16;
      v_nCPAPData               number := 32;
      v_nStep number := 0;
      v_nCount       number;
      v_nRecCount    number := 0;
      v_nCurrentStep number := 0;
   begin
      v_vSql := 'select count(*) from tbicds.patient_treatment_step where patient_id = :P0';
      execute immediate v_vSql into v_nRecCount using pi_vPatientID;
   
      if v_nRecCount > 0 then
         v_vSql := 'select treatment_step from tbicds.patient_treatment_step where patient_id = :P0';
         execute immediate v_vSql into v_nCurrentStep using pi_vPatientID;
      end if;
   
      if (bitand(v_nCurrentStep, v_nProfile) = v_nProfile) then
         v_nStep := v_nStep + v_nProfile;
      end if;
   
      --check status of Baseline questionnaires
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_module '
                || 'where patient_id = :P0 '
                || 'and (module_group_id = 2 and status = 1) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nStartedBaseline;
      end if;
   
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and (t.status = 1 and t.event_id = 5) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nBaselineQuestionnaires;
      end if;
   
      --check status of video events
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and (t.status = 1 and t.event_id in (3, 4)) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;

      if v_nCount = 1 then
         v_nStep := v_nStep + v_nStartedVideos;
      elsif v_nCount = 2 then
         v_nStep := v_nStep + v_nStartedVideos + v_nVideos;
      end if;
   
      --check status of CPAP Data
      v_nCount := 0;
      v_vSql := 'select count(*) from tbicds.patient_cpap t where t.patient_id = :P0 ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nCPAPData;
      end if;
   
      --insert or update
      if v_nRecCount > 0 then
         v_vSql := 'update tbicds.patient_treatment_step t '
                   || 'set t.treatment_step = :P0 '
                   || 'where t.patient_id = :P1 ';
         execute immediate v_vSql using v_nStep, pi_vPatientID;
      else
         v_vSql := 'insert into tbicds.patient_treatment_step (patient_id, treatment_step) '
                   || 'values (:P0, :P1) ';
         execute immediate v_vSql using pi_vPatientID, v_nStep;
      end if;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PATIENT_TX_STEP.UpdatePatientSteps(): ' || sqlErrm;
   end;

   /*
   remove patient step
   */
   procedure DeletePatientStep(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID in varchar2,
                              pi_nStep      in number,
                              po_nStatusCode    out number,
                              po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nStep        number;
      v_nRecCount    number := 0;
      v_nCurrentStep number := 0;
   begin
      v_vSql := 'select count(*) from tbicds.patient_treatment_step where patient_id = :P0';
      execute immediate v_vSql into v_nRecCount using pi_vPatientID;
   
      if v_nRecCount > 0 then
         v_vSql := 'select treatment_step from tbicds.patient_treatment_step where patient_id = :P0';
         execute immediate v_vSql into v_nCurrentStep using pi_vPatientID;
      
         if (bitand(v_nCurrentStep, pi_nStep) = pi_nStep) then
            v_nStep := v_nCurrentStep - pi_nStep;
         end if;
         
         v_vSql := 'update tbicds.patient_treatment_step set treatment_step = :P0 where patient_id = :P1';
         execute immediate v_vSql using v_nStep, pi_vPatientID;
         commit;
      end if;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PATIENT_TX_STEP.DeletePatientStep(): ' || sqlErrm;
   end;

   /*
   Get patient step recordset
   */
   procedure GetPatientStepRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vPatientID in varchar2,
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2,
                             rs                out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      v_vSql := 'select nvl(t.treatment_step, 0) as step, '
                || 'nvl(t.notification_step, 0) as notification_step '
                || 'from tbicds.patient_treatment_step t '
                || 'where t.patient_id = :P0 ';
      open rs for v_vSql using pi_vPatientID;
   
   exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT_TX_STEP.GetPatientStepRS(): ' || sqlErrm;
   end;

   /*
   Update notification step
   */
   procedure UpdateNotificationStep(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID        in varchar2,
                                   pi_nNotificationStep in number,
                                   po_nStatusCode    out number,
                                   po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nNotificationStep number := 0;
   begin
      v_vSql := 'select notification_step from tbicds.patient_treatment_step where patient_id = :P0';
      execute immediate v_vSql into v_nNotificationStep using pi_vPatientID;
   
      if bitand(v_nNotificationStep, pi_nNotificationStep) = 0 then
         v_nNotificationStep := v_nNotificationStep + pi_nNotificationStep;
         
         v_vSql := 'update tbicds.patient_treatment_step set notification_step = :P0 where patient_id = :P1';
         execute immediate v_vSql using v_nNotificationStep, pi_vPatientID;
         commit;
      end if;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PATIENT_TX_STEP.UpdateNotificationStep(): ' || sqlErrm;
   end;

end;
/

